# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
import Tracing
from LdpMode import LdpMode # pylint:disable=F0401

th = Tracing.Handle( 'PseudowireCliMode' )
t0 = th.t0

class PatchPanelMode( CliMode.ConfigMode ):
   def __init__( self ):
      self.modeKey = 'patch'
      self.longModeKey = 'patch'
      CliMode.ConfigMode.__init__( self, None )

   def enterCmd( self ):
      return 'patch panel'

   def commentKey( self ):
      return self.longModeKey

class PatchMode( CliMode.ConfigMode ):
   def __init__( self, patchName ):
      self.patchName = patchName
      self.modeKey = 'patch-%s' % patchName
      self.longModeKey = 'patch-%s' % patchName
      CliMode.ConfigMode.__init__( self, patchName, parentMode=PatchPanelMode )

   def enterCmd( self ):
      return 'patch ' + self.patchName

   def commentKey( self ):
      return self.longModeKey

class FxcMode( CliMode.ConfigMode ):
   def __init__( self, patchName ):
      self.patchName = patchName
      self.modeKey = 'fxc-%s' % patchName
      self.longModeKey = 'flexible-cross-connect-%s' % patchName
      CliMode.ConfigMode.__init__( self, patchName, parentMode=PatchPanelMode )
      t0( "FxcMode init", repr( patchName ), "modeKey", repr( self.modeKey ),
            "longModeKey", repr( self.longModeKey ) )

   def enterCmd( self ):
      return 'flexible-cross-connect ' + self.patchName

   def commentKey( self ):
      return self.longModeKey

class MplsLdpPseudowiresMode( CliMode.ConfigMode ):
   def __init__( self ):
      self.modeKey = 'mpls-ldp-pw'
      self.longModeKey = 'mpls-ldp-pw'
      CliMode.ConfigMode.__init__( self, None, parentMode=LdpMode )

   def enterCmd( self ):
      return 'pseudowires'
   
   def commentKey( self ):
      return self.longModeKey

class LdpPseudowireMode( CliMode.ConfigMode ):
   def __init__( self, ldpPwName ):
      self.ldpPwName = ldpPwName
      self.modeKey = "mpls-ldp-pw-" + ldpPwName
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, ldpPwName,
                                   parentMode=MplsLdpPseudowiresMode )

   def enterCmd( self ):
      return "pseudowire " + self.ldpPwName

   def commentKey( self ):
      return self.longModeKey
