# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliMode

class PowerManagementMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'system power'

   def __init__( self ):
      self.modeKey = 'pwrmgmt'
      self.longModeKey = 'pwrmgmt'
      CliMode.ConfigMode.__init__( self, None, parentMode=CliMode.ConfigMode )

class PowerManagementCardMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'module %s' % ( self.cardName )

   def __init__( self, param ):
      self.cardName = param
      self.modeKey = 'pwrmgmt-card'
      self.longModeKey = 'pwrmgmt-%s' % ( self.cardName )

      CliMode.ConfigMode.__init__( self, param, parentMode=PowerManagementMode )
