#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
import re

class ClassMapModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'class-map type %s match-any %s' % ( self.mapStr, self.cmapName )

   def __init__( self, param ):
      ( self.mapType, self.mapStr, self.cmapName ) = param
      self.modeKey = 'cmap'
      self.longModeKey = 'cmap-%s-%s' % ( self.mapStr, self.cmapName )
      CliMode.ConfigMode.__init__( self, self.longModeKey )


class PolicyMapModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'policy-map type %s %s' % ( self.mapStr, self.pmapName )

   def __init__( self, param ):
      ( self.mapType, self.mapStr, self.pmapName ) = param
      self.modeKey = 'pmap'
      self.longModeKey = 'pmap-%s-%s' % ( self.mapStr, self.pmapName )
      CliMode.ConfigMode.__init__( self, self.longModeKey )


class PolicyMapClassModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      if self.prio:
         return '%s class %s' % ( self.prio, self.cmapName )
      else:
         return 'class %s' % self.cmapName

   def filterExp( self ):
      return ( r'^\d+ class ' + re.escape( self.cmapName ) + '$' )

   def __init__( self, param ):
      if len( param ) == 5:
         ( self.mapType, self.mapStr, self.pmapName, self.cmapName,
           self.prio ) = param
      else:
         ( self.mapType, self.mapStr, self.pmapName, self.cmapName ) = param
         self.prio = None
      self.modeKey = 'pmap-c'
      self.longModeKey = 'pmap-c-%s-%s-%s' % \
          ( self.mapStr, self.pmapName, self.cmapName )
      CliMode.ConfigMode.__init__( self, self.longModeKey, 
                                   parentMode=CliMode.ConfigMode )
