#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliMode

class PoeMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'poe'

   def __init__( self ):
      self.modeKey = 'poe'
      self.longModeKey = 'poe'
      CliMode.ConfigMode.__init__( self, None, parentMode=CliMode.ConfigMode )

class PoeLinecardMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'module Linecard%s' % ( self.number )

   def __init__( self, param ):
      self.number = str( param )
      self.modeKey = 'poe-linecard'
      self.longModeKey = 'poe-linecard%s' % ( self.number )

      CliMode.ConfigMode.__init__( self, param, parentMode=PoeMode )
