#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from IpLibConsts import DEFAULT_VRF

class RoutingPimBsrMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'router pim bsr'

   def __init__( self, param ):
      self.modeKey = 'router'
      self.longModeKey = 'router-pim-bsr'
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return self.longModeKey

class RoutingPimBsrVrfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.param_

   def __init__( self, param ):
      assert param != DEFAULT_VRF
      self.modeKey = 'router'
      self.longModeKey = 'router-pim-bsr-vrf-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingPimBsrMode )

   def commentKey( self ):
      return self.longModeKey

class RoutingPimBsrAfMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return str( self.af )

   def __init__( self, vrfName, af ):
      self.modeKey = 'router'
      self.af = af
      self.vrfName = vrfName
      if vrfName == DEFAULT_VRF:
         self.longModeKey = 'router-pim-bsr-%s' % af
      else:
         self.longModeKey = 'router-pim-bsr-vrf-%s-%s' % ( vrfName, af )
      CliMode.ConfigMode.__init__( self, ( vrfName, af ) )

   def commentKey( self ):
      return self.longModeKey

