# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from IpLibConsts import DEFAULT_VRF

class RoutingPimBidirBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'router pim bidirectional'

   def __init__( self, param ):
      self.modeKey = 'router'
      self.longModeKey = 'router-pim-bidir'
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return self.longModeKey

class RoutingPimBidirVrfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.param_

   def __init__( self, param ):
      assert param != DEFAULT_VRF
      self.modeKey = 'router'
      self.longModeKey = 'router-pim-bidir-vrf-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingPimBidirBaseMode )

   def commentKey( self ):
      return self.longModeKey

class RoutingPimBidirAfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return str( self.af )

   def __init__( self, vrfName, af ):
      self.modeKey = 'router'
      self.af = af
      self.vrfName = vrfName
      if vrfName == DEFAULT_VRF:
         self.longModeKey = 'router-pim-bidir-%s' % af
      else:
         self.longModeKey = 'router-pim-bidir-vrf-%s-%s' % ( vrfName, af )
      CliMode.ConfigMode.__init__( self, ( vrfName, af ) )

   def commentKey( self ):
      return self.longModeKey
