#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from IpLibConsts import DEFAULT_VRF

class RoutingOspf3Mode( CliMode.ConfigMode ):

   def enterCmd( self ):
      if self.vrfName != DEFAULT_VRF:
         return 'ipv6 router ospf %d vrf %s' % ( self.processId, self.vrfName )
      return 'ipv6 router ospf %d' % self.processId

   def __init__( self, param ):
      self.processId, self.vrfName = param
      # The industry standard cli has "config-router" as the prompt
      # for this mode.
      self.modeKey = "router"
      if self.vrfName == DEFAULT_VRF:
         self.longModeKey = "router-ospf3"
      else:
         self.longModeKey = "router-ospf3-vrf-%s" % self.vrfName
      CliMode.ConfigMode.__init__( self, param )
