#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from IpLibConsts import DEFAULT_VRF

class RoutingOspfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      if self.vrfName != DEFAULT_VRF:
         return 'router ospf %d vrf %s' % \
            ( self.instance, self.vrfName )
      return 'router ospf %d' % self.instance

   def __init__( self, param ):
      self.instance, self.vrfName = param
      # The industry standard cli has "config-router" as the prompt
      # for this mode.
      self.modeKey = "router"
      if self.vrfName == DEFAULT_VRF:
         self.longModeKey = "router-ospf"
      else:
         self.longModeKey = "router-ospf-vrf-%s" % self.vrfName
      CliMode.ConfigMode.__init__( self, param )

class RoutingOspfGeneralMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'router ospf general'

   def __init__( self, param ):
      self.modeKey = "router"
      self.longModeKey = "router-ospf-general"
      CliMode.ConfigMode.__init__( self, param )

class RoutingOspfTeMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'traffic-engineering'
   
   def __init__( self, param ):
      self.vrfName = param
      self.modeKey = "router"
      self.longModeKey = "router-ospf-te"
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingOspfMode )

class RoutingOspfSrMplsMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'segment-routing mpls'

   def __init__( self, param ):
      self.instanceName = param
      self.modeKey = "router"
      self.longModeKey = "router-ospf-sr-mpls"
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingOspfMode )
