# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class OpenStackMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      """ Subclasses should override this method to return the command
      to be used to enter this CLI mode instance."""
      raise NotImplementedError

   def __init__( self, param ):
      self.modeKey = 'cvx-openstack'
      if param:
         self.longModeKey = 'cvx-openstack-%s' % param
      else:
         self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, None, parentMode=CliMode.ConfigMode )

#-------------------------------------------------------------------------------
# Service OpenStack mode
#-------------------------------------------------------------------------------

class OpenStackConfigModeBase( OpenStackMode ):

   def enterCmd( self ):
      return 'service openstack'

#-------------------------------------------------------------------------------
# Region config mode under service openstack mode
#-------------------------------------------------------------------------------

class RegionConfigModeBase( OpenStackMode ):

   def enterCmd( self ):
      return 'region %s' % self.regionName

   def __init__( self, param ):
      self.regionName = param
      OpenStackMode.__init__( self, param )

class TenantConfigModeBase( OpenStackMode ):

   def enterCmd( self ):
      # Fill this in if Tenant needs to be shown in running config
      pass

class NetworkConfigModeBase( OpenStackMode ):

   def enterCmd( self ):
      # Fill this in if Tenant needs to be shown in running config
      pass

class TenantVmConfigModeBase( OpenStackMode ):

   def enterCmd( self ):
      # Fill this in if Tenant needs to be shown in running config
      pass

class TenantInstanceConfigModeBase( OpenStackMode ):

   def enterCmd( self ):
      # Fill this in if Tenant needs to be shown in running config
      pass

class PortConfigModeBase( OpenStackMode ):

   def enterCmd( self ):
      # Fill this in if Tenant needs to be shown in running config
      pass
