#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class OpenFlowMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'openflow'

   def __init__( self, param ):
      self.modeKey = "openflow"
      self.longModeKey = "openflow"
      CliMode.ConfigMode.__init__( self, param )

class FlowEntryCMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "flow %s" % self.param_

   def __init__( self, param ):
      self.modeKey = "openflow-flow"
      tmp = param.split()[0]
      self.longModeKey = "openflow-%s" % tmp
      CliMode.ConfigMode.__init__( self, param )

class ControllerMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "controller %s" % self.controller

   def __init__( self, param ):
      self.modeKey = "openflow-controller"
      self.controller = param
      self.longModeKey = "openflow-%s" % self.controller.split( ':', 1 )[ 1 ]
      CliMode.ConfigMode.__init__( self, self.longModeKey, parentMode=OpenFlowMode )
