#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MgmtNetconfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'management api netconf'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = 'mgmt-%s' % param
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return self.longModeKey

   # makes sure all management configurations are together
   @classmethod
   def modeSortKey( cls ):
      return 'mgmt-' + cls.__name__

class NetconfTransportMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'transport ssh %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = 'netconf-transport-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtNetconfMode )

   def commentKey( self ):
      return self.longModeKey
