#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MssPolicyMonitorDynamic( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'dynamic device-set %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'cvx-mss-%s' % param
      self.longModeKey = 'cvx-mss-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.Mss.MssMode )

class MssPolicyMonitorDevice( CliMode.ConfigMode ):
   def enterCmd( self ):
      if self.param_[ 2 ]:
         return 'device member %s' % ( self.deviceName )
      else:
         return 'device %s' % self.deviceName

   def __init__( self, param ):
      self.modeKey = 'cvx-mss-%s-%s' % ( param[ 1 ], param[ 0 ] )
      self.deviceName = param[ 0 ]
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=MssPolicyMonitorDynamic )

class MssPolicyMonitorVInst( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'virtual instance %s' % self.vinstName

   def __init__( self, param ):
      self.vinstName = param[ 2 ]
      self.sdName = param[ 1 ]
      self.dsName = param[ 0 ]
      self.modeKey = 'cvx-mss-%s-%s-%s' % param
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param, parentMode=MssPolicyMonitorDevice )

class MssPolicyMonitorVrf( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'vrf %s' % self.vrfName

   def __init__( self, param ):
      self.vrfName = param[ 2 ]
      self.sdName = param[ 1 ]
      self.dsName = param[ 0 ]
      self.modeKey = 'cvx-mss-%s-%s-%s' % param
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param, parentMode=MssPolicyMonitorDevice )

class MssPolicyMonitorRoute( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'next-hop address ipv4 %s' % self.ipv4

   def __init__( self, param ):
      self.ipv4 = param[ 3 ]
      self.vrfName = param[ 2 ]
      self.sdName = param[ 1 ]
      self.dsName = param[ 0 ]
      self.modeKey = 'cvx-mss-%s-%s-%s-%s' % param
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param, parentMode=MssPolicyMonitorVrf )

