#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from IpLibConsts import DEFAULT_VRF

class RoutingMsdpBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'router msdp'

   def __init__( self, param ):
      self.modeKey = 'router'
      self.longModeKey = 'router-msdp'
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return self.longModeKey

class RoutingMsdpVrfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.param_

   def __init__( self, param ):
      assert param != DEFAULT_VRF
      self.modeKey = 'router'
      self.longModeKey = 'router-msdp-vrf-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingMsdpBaseMode )

   def commentKey( self ):
      return self.longModeKey

class RoutingMsdpPeerMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'peer ' + str( self.peer )

   def __init__( self, vrfName, peer ):
      self.modeKey = 'router'
      self.peer = peer
      self.vrfName = vrfName
      if vrfName == DEFAULT_VRF:
         self.longModeKey = 'router-msdp-peer-%s' % peer
      else:
         self.longModeKey = 'router-msdp-vrf-%s-peer-%s' % ( vrfName, peer )
      CliMode.ConfigMode.__init__( self, ( vrfName, peer ) )

   def commentKey( self ):
      return self.longModeKey
