#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from IpLibConsts import DEFAULT_VRF

class RoutingMulticastMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'router multicast'

   def __init__( self, param ):
      self.modeKey = 'router'
      self.longModeKey = 'router-multicast'
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return self.longModeKey

class RoutingMulticastVrfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.param_

   def __init__( self, param ):
      assert param != DEFAULT_VRF
      self.modeKey = 'router'
      self.longModeKey = 'router-multicast-vrf-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingMulticastMode )

   def commentKey( self ):
      return self.longModeKey

class RoutingMulticastAfMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return str( self.af )

   def __init__( self, vrfName, af ):
      self.modeKey = 'router'
      self.af = af
      self.vrfName = vrfName
      if vrfName == DEFAULT_VRF:
         self.longModeKey = 'router-multicast-%s' % af
      else:
         self.longModeKey = 'router-multicast-vrf-%s-%s' % ( vrfName, af )

      CliMode.ConfigMode.__init__( self, ( vrfName, af ) )

   def commentKey( self ):
      return self.longModeKey

