#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class StaticMulticastModeBase( CliMode.ConfigMode ):

   def __init__( self, inLabel ):
      self.modeKey = 'mpls'
      self.longModeKey = 'mpls-mcast-route-%s' % inLabel
      self.inLabel = inLabel
      CliMode.ConfigMode.__init__( self, inLabel )

   def enterCmd( self ):
      return "mpls static multicast top-label %s" % self.inLabel

class TunnelStaticModeBase( CliMode.ConfigMode ):

   def __init__( self, tunName, tep ):
      self.modeKey = 'mpls'
      self.longModeKey = 'mpls-tunnel-%s' % tunName
      self.tunName = tunName
      self.tep = tep
      CliMode.ConfigMode.__init__( self, tunName )

   def enterCmd( self ):
      return "mpls tunnel static %s %s" % ( self.tunName, self.tep )
