# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MgmtModelsMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'management api models'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = 'mgmt-%s' % param
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return self.longModeKey

   # makes sure all management configurations are together
   @classmethod
   def modeSortKey( cls ):
      return 'mgmt-' + cls.__name__

class ProviderAFTMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'provider aft'

   def __init__( self, param ):
      self.modeKey = 'provider'
      self.longModeKey = 'provider-aft'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtModelsMode )

   def commentKey( self ):
      return self.longModeKey

class ProviderSmashMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'provider smash'

   def __init__( self, param ):
      self.modeKey = 'provider'
      self.longModeKey = 'provider-smash'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtModelsMode )

   def commentKey( self ):
      return self.longModeKey

class ProviderSysdbMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'provider sysdb'

   def __init__( self, param ):
      self.modeKey = 'provider'
      self.longModeKey = 'provider-sysdb'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtModelsMode )

   def commentKey( self ):
      return self.longModeKey
