# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MldSnoopingMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'mld snooping'

   def __init__( self ):
      self.modeKey = 'mld-snooping'
      self.longModeKey = 'mld-snooping'
      CliMode.ConfigMode.__init__( self, None )

class MldSnoopingVlanMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'vlan %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'mld-snooping-vlan'
      self.longModeKey = 'mld-snooping-vlan-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=MldSnoopingMode )
