# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.MaintenanceMode import MaintenanceMode

class MaintenanceUnitMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'unit %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'unit'
      self.longModeKey = 'unit-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=MaintenanceMode )

   def commentKey( self ):
      return self.longModeKey
