# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MacsecBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'mac security'

   def __init__( self, param ):
      self.modeKey = "mac-security"
      self.longModeKey = "mac-security"
      CliMode.ConfigMode.__init__( self, param )

class MacsecProfileBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'profile %s' % self.profileName

   def __init__( self, param ):
      self.modeKey = "profile"
      self.profileName = param
      self.longModeKey = "mac-security-profile-%s" % self.profileName

      CliMode.ConfigMode.__init__( self, param )

class MacsecProfileStaticSakMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'secure channel %s' % self.txOrRx

   def __init__( self, param ):
      self.modeKey = "static-sak"
      self.txOrRx = param[ 1 ]
      profileName = param[ 0 ]
      self.longModeKey = "mac-security-profile-%s-sc-%s" \
            % ( profileName, self.txOrRx )

      CliMode.ConfigMode.__init__( self, param )
