#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
import Toggles.LdpToggleLib

class LdpMode( CliMode.ConfigMode ):
   
   def enterCmd( self ):
      return 'mpls ldp'

   def __init__( self ):
      self.modeKey = "mpls-ldp"
      self.longModeKey = "mpls-ldp"
      CliMode.ConfigMode.__init__( self, 'ldp' )

if Toggles.LdpToggleLib.toggleP2mpToggleEnabled():
   class MldpMode( CliMode.ConfigMode ):
      '''mldp will be a child mode of ldp'''
   
      def enterCmd( self ):
         return 'mldp'

      def __init__( self ):
         self.modeKey = "mpls-ldp-mldp"
         self.longModeKey = "mpls-ldp-mldp"
         CliMode.ConfigMode.__init__( self, 'mldp', parentMode=LdpMode )

if Toggles.LdpToggleLib.toggleGrToggleEnabled():
   class GrHelperMode( CliMode.ConfigMode ):
      '''gr helper will be a child mode of ldp'''

      def enterCmd( self ):
         return 'graceful-restart role helper'

      def __init__( self ):
         key = 'mpls-ldp-gr-helper'
         self.modeKey = key
         self.longModeKey = key
         CliMode.ConfigMode.__init__( self, 'grHelper', parentMode=LdpMode )

   class GrSpeakerMode( CliMode.ConfigMode ):
      '''gr speaker will be a child mode of ldp'''

      def enterCmd( self ):
         return 'graceful-restart role speaker'

      def __init__( self ):
         key = 'mpls-ldp-gr-speaker'
         self.modeKey = key
         self.longModeKey = key
         CliMode.ConfigMode.__init__( self, 'grSpeaker', parentMode=LdpMode )
