#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from IpLibConsts import DEFAULT_VRF
DEFAULT_LDAP_PORT = 389

class ServerConfigModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'server %s' % ( self.param_, )

   def __init__( self, hostname, vrf=DEFAULT_VRF, port=DEFAULT_LDAP_PORT ):
      self.modeKey = 'ldap'
      param = hostname
      param = ( param + '-' + vrf ) if vrf != DEFAULT_VRF else param
      param = ( param + ':' + port ) if port != DEFAULT_LDAP_PORT else param
      self.longModeKey = 'ldap-%s' % param
      CliMode.ConfigMode.__init__( self, param )

class GroupPolicyConfigModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'group policy %s' % ( self.param_, )

   def __init__( self, param ):
      self.modeKey = 'mgmt-ldap-gp'
      self.longModeKey = 'mgmt-ldap-gp-%s' % param
      CliMode.ConfigMode.__init__( self, param )

class LdapServerGroupModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'aaa group server ldap %s' % self.param_

   def __init__( self, param ):
      self.modeKey = "sg-ldap"
      self.longModeKey = "sg-ldap-%s" % param
      CliMode.ConfigMode.__init__( self, param )
