# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class L2ProtocolModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'l2-protocol'

   def __init__( self, param ):
      self.modeKey = 'l2p'
      self.longModeKey = 'l2-protocol'
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.ConfigMode )

class L2ProtocolProfileModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'forwarding profile %s' % self.profileName

   def __init__( self, param ):
      self.profileName = param
      self.modeKey = 'l2p-fwd-profile'
      self.longModeKey = 'l2p-fwd-profile-%s' % self.profileName
      CliMode.ConfigMode.__init__( self, self.profileName,
                                   parentMode=L2ProtocolModeBase )


