# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.Ira import RouterKernelMode

class RouterKernelAfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'address-family %s' % self.addrFamily

   def __init__( self, param ):
      self.vrfName, self.addrFamily = param
      self.modeKey = 'router'
      self.longModeKey = 'router-kernel-vrf-%s-af-%s' % ( self.vrfName, 
                                                          self.addrFamily )
      CliMode.ConfigMode.__init__( self, param, parentMode=RouterKernelMode )


