#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from IpLibConsts import DEFAULT_VRF

class RoutingIsisMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      if self.vrfName == DEFAULT_VRF:
         if self.instanceId:
            return 'router isis %s instance-id %d' % ( self.instanceName,
                                                       self.instanceId )
         else:
            return 'router isis %s' % self.instanceName
      else:
         return 'router isis %s vrf %s' % ( self.instanceName, self.vrfName )

   def __init__( self, param ):
      self.instanceName, self.instanceId, self.vrfName = param
      # The industry standard cli has "config-router" as the prompt
      # for this mode.
      self.modeKey = "router"
      if self.vrfName == DEFAULT_VRF:
         self.longModeKey = "router-isis"
      else:
         self.longModeKey = "router-isis-vrf-%s" % self.vrfName
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      if self.vrfName == DEFAULT_VRF:
         if self.instanceId:
            return 'router isis %s instance-id %d' % ( self.instanceName,
                                                       self.instanceId )
         else:
            return 'router isis %s' % self.instanceName
      else:
         return 'router isis %s vrf %s' % ( self.instanceName, self.vrfName )

class RoutingIsisAfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'address-family %s %s' % ( self.addrFamily, self.modifier )

   def __init__( self, param ):
      # self.addrFamily is either "ipv4" or "ipv6"
      # self.modifier is either "unicast" or "multicast"
      self.vrfName, self.addrFamily, self.modifier, self.instanceId = param
      # The industry standard cli has "config-router-af" as the prompt
      # for this mode (i.e. no '-v4'/'-v6' suffix).
      self.modeKey = "router"
      if self.vrfName == DEFAULT_VRF:
         self.longModeKey = "router-isis-af"
      else:
         self.longModeKey = "router-isis-vrf-%s-af" % self.vrfName
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingIsisMode )

   def commentKey( self ):
      if self.vrfName == DEFAULT_VRF:
         if self.instanceId:
            return "router-isis-af-%s-id-%s" % (self.addrFamily, self.instanceId)
         return "router-isis-af-%s" % self.addrFamily
      else:
         return "router-isis-vrf-%s-af-%s" % ( self.vrfName, self.addrFamily )

class RoutingIsisSrMplsMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'segment-routing mpls'

   def __init__( self, param ):
      self.instanceName = param
      self.modeKey = "router"
      self.longModeKey = "router-isis-sr-mpls"
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingIsisMode )

class RoutingIsisMetricProfileMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'metric profile %s' % self.metricProfileName

   def __init__( self, param ):
      self.metricProfileName = param
      self.longModeKey = "router-isis-metric"
      self.modeKey = self.longModeKey
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingIsisMode )

class RoutingIsisTeMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'traffic-engineering'

   def __init__( self, param ):
      self.vrfName = param
      self.modeKey = "router"
      self.longModeKey = "router-isis-te"
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingIsisMode )

class RoutingIsisAreaProxyMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'area proxy'

   def __init__( self, param ):
      self.vrfName = param
      self.modeKey = "router"
      self.longModeKey = "router-isis-area-proxy"
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingIsisMode )
