#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from IpLibConsts import DEFAULT_VRF

class VrfDefinitionBaseMode( CliMode.ConfigMode ):
   def __init__( self, vrfName ):
      self.modeKey = 'vrf'
      self.longModeKey = 'vrf-%s' % vrfName
      self.vrfName_ = vrfName
      CliMode.ConfigMode.__init__( self, vrfName )

   def enterCmd( self ):
      return 'vrf instance %s' % self.vrfName_

class NexthopGroupConfigBase( CliMode.ConfigMode ):
   def __init__( self, nexthopGroupName, nexthopGroupType ):
      self.modeKey = 'nexthop-group'
      self.longModeKey = 'nexthop-group-%s' % nexthopGroupName
      self.nexthopGroupName_ = nexthopGroupName
      self.nexthopGroupType = nexthopGroupType
      CliMode.ConfigMode.__init__( self, nexthopGroupName )

   def enterCmd( self ):
      return 'nexthop-group %s type %s' % ( self.nexthopGroupName_,
                                            self.nexthopGroupType )

class RouterKernelMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      if self.vrfName != DEFAULT_VRF:
         return 'router kernel vrf %s' % ( self.vrfName )
      return 'router kernel'

   def __init__( self, param ):
      self.vrfName = param
      self.modeKey = "router"
      if self.vrfName == DEFAULT_VRF:
         self.longModeKey = "router-kernel"
      else:
         self.longModeKey = "router-kernel-vrf-%s" % self.vrfName
      CliMode.ConfigMode.__init__( self, param )
