# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class IkePolicyMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'ike policy %s' % self.param_

   def __init__( self, param ):
      self.modeKey = "ike"
      self.longModeKey = "ipsec-ike"
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return self.longModeKey

class SecurityAssociationMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'sa policy %s' % self.param_

   def __init__( self, param ):
      self.modeKey = "sa"
      self.longModeKey = "ipsec-sa"
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return self.longModeKey

class SecurityAssociationVxlanMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'sa policy vxlan security %s' % self.param_

   def __init__( self, param ):
      self.modeKey = "sa"
      self.longModeKey = "ipsec-sa"
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return "ipsec-vxlan-sa"

class IpSecurityMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'ip security'

   def __init__( self ):
      self.modeKey = "ipsec"
      self.longModeKey = "ipsec"
      CliMode.ConfigMode.__init__( self, 1 )

   def commentKey( self ):
      return self.longModeKey

class IpsecProfileMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'profile %s' % self.param_

   def __init__( self, param ):
      self.modeKey = "ipsec"
      self.longModeKey = "ipsec-profile"
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return self.longModeKey

class KeyControllerMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "key controller"

   def __init__( self ):
      self.modeKey = "key-controller"
      self.longModeKey = "ipsec-key-controller"
      CliMode.ConfigMode.__init__( self, 1 )

   def commentKey( self ):
      return self.longModeKey
