#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.MaintenanceMode import MaintenanceMode

class IntfMaintenanceMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'interface %s' % self.param_

   def __init__( self, param, shortName ):
      self.modeKey = 'maint-if'
      self.longModeKey = 'maint-if-%s' % shortName
      CliMode.ConfigMode.__init__( self, param, parentMode=MaintenanceMode )

   def commentKey( self ):
      return self.longModeKey

