# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class IntfGroupMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'group interface %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'group-if'
      self.longModeKey = 'group-if-%s' % param
      CliMode.ConfigMode.__init__( self, param )

class IntfBuiltinGroupMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'group interface %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'builtin-group-if'
      self.longModeKey = 'builtin-group-if-%s' % param
      CliMode.ConfigMode.__init__( self, param )


