#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from TypeFuture import TacLazyType

intfId = TacLazyType( 'Arnet::IntfId' )

class IntfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'interface %s' % self.param_

   def __init__( self, param, shortName ):
      self.modeKey = "if"
      self.longModeKey = "if-%s" % shortName
      CliMode.ConfigMode.__init__( self, param )

   @staticmethod
   def getShortname( intf ):
      '''intf is either an Arnet::IntfId or a string
      representation of an interface name'''
      if isinstance( intf, str ):
         try:
            intf = intfId( intf )
         except IndexError:
            # Could not convert to IntfId
            return intf
      # Not all interfaces have shortnames, so if shortname
      # is empty just return the long name.
      return intf.shortName or intf.stringValue
