#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class IgmpProfileMode( CliMode.ConfigMode ):
   
   def enterCmd( self ):
      return 'ip igmp profile %s' % self.param_

   def __init__( self, param ):
      self.modeKey = "igmp-profile"
      self.action = "deny"
      self.param_ = param
      self.longModeKey = None
      self.setLongModeKey()
      CliMode.ConfigMode.__init__( self, param )
   
   def setLongModeKey( self ):
      self.longModeKey = "igmp-profile-%s-%s" % ( self.param_,
                                                  self.action )

