#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class HttpServerVrfConfigModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.vrfName_
   
   def __init__( self, param ):
      ( self.vrfName_, self.config_ ) = param
      self.modeKey = "mgmt-http-server-vrf"
      self.longModeKey = "mgmt-http-server-vrf-%s" % self.vrfName_
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.ConfigMode )

   def config( self ):
      return self.config_.vrfConfig.newMember( self.vrfName_ )

   def shutdown( self ):
      self.config().serverState = "disabled"

   def noShutdown( self ):
      self.config().serverState = "enabled"

   def defaultShutdown( self ):
      # delete the entry if vrfConfig is all empty
      cfg = self.config_.vrfConfig.get( self.vrfName_ )
      if cfg:
         if cfg.vrfService:
            cfg.serverState = "globalDefault"
         else:
            del self.config_.vrfConfig[ self.vrfName_ ]
