#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MgmtGnmiMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'management api gnmi'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = 'mgmt-%s' % param
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return self.longModeKey

   # makes sure all management configurations are together
   @classmethod
   def modeSortKey( cls ):
      return 'mgmt-' + cls.__name__

class GnmiTransportMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'transport grpc %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = 'gnmi-transport-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtGnmiMode )

   def commentKey( self ):
      return self.longModeKey
