#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.FlowTracking import FlowTrackingModeBase
import Tracing

traceHandle = Tracing.Handle( 'FlowTrackerMode' )
t0 = traceHandle.trace0
class TrackerModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'tracker %s' % self.trName

   def __init__( self, param ):
      t0( "TrackerModeBase: ", param )
      ( self.ftrTypeStr, self.trName ) = param
      self.modeKey = "ftr-tr"
      ftrPrompt = self.ftrTypeStr.replace( ' ', '-' )
      self.longModeKey = "ftr-%s-tr-%s" % ( ftrPrompt, self.trName )
      CliMode.ConfigMode.__init__( self, param,
            parentMode=FlowTrackingModeBase )

   def instanceRuleKey( self ):
      return self.longModeKey
