# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliMode
from CliMode.FlowTracker import TrackerModeBase
import BasicCli
import CliParser
from FlowTrackerCliUtil import ftrTypeKwStr

class GroupsModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'groups'

   def __init__( self, param ):
      ( self.ftrTypeStr, self.trName ) = param
      self.modeKey = 'ftr-tr-grps'
      ftrPrompt = self.ftrTypeStr.replace( ' ', '-' )
      self.longModeKey = 'ftr-%s-tr-%s-grps' % ( ftrPrompt, self.trName )
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=TrackerModeBase )

   def instanceRuleKey( self ):
      return self.longModeKey

class GroupsMode( GroupsModeBase, BasicCli.ConfigModeBase ):
   name = 'Flow groups configuration'
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session ):
      self.session_ = session
      self.context_ = parent.context_
      GroupsModeBase.__init__( self,
                               ( ftrTypeKwStr[ self.context_.ftrType() ],
                               self.context_.trackerName() ) )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def context( self ):
      return self.context_

class GroupModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'group %s' % self.fgName

   def __init__( self, param ):
      ( self.ftrTypeStr, self.trName, self.fgName ) = param
      self.modeKey = 'ftr-tr-grps-grp'
      ftrPrompt = self.ftrTypeStr.replace( ' ', '-' )
      self.longModeKey = 'ftr-%s-tr-%s-grps-grp-%s' % (
                                    ftrPrompt, self.trName, self.fgName )
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=GroupsModeBase )

   def instanceRuleKey( self ):
      return self.longModeKey

class GroupMode( GroupModeBase, BasicCli.ConfigModeBase ):
   name = 'Flow group configuration'
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session, context, groupName ):
      self.session_ = session
      self.context_ = context
      GroupModeBase.__init__( self, ( ftrTypeKwStr[ context.ftrType() ],
                                      context.trackerName(),
                                      groupName ) )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def context( self ):
      return self.context_
