#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.Classification import AppTrafficRecModeBase

#-------------------------------------------------------------------------------
# The "config-app-rec-app" mode.
#-------------------------------------------------------------------------------
class FirewallServiceConfigMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'application %s' % self.serviceName_

   def __init__( self, param ):
      self.serviceName_ = param
      self.modeKey = "app-rec-app"
      self.longModeKey = "app-rec-app-%s" % self.serviceName_
      CliMode.ConfigMode.__init__( self, param, parentMode=AppTrafficRecModeBase )

   def commentKey( self ):
      return self.longModeKey

#-------------------------------------------------------------------------------
# The "config-router-seg-sec" mode.
#-------------------------------------------------------------------------------
class FirewallConfigMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'router segment-security'

   def __init__( self, param ):
      self.modeKey = "router-seg-sec"
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.ConfigMode )

   def commentKey( self ):
      return self.longModeKey

#-------------------------------------------------------------------------------
# The "config-router-seg-sec-policy" mode.
#-------------------------------------------------------------------------------
class FirewallPolicyConfigMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'policy %s' % self.policyName_

   def __init__( self, param ):
      self.policyName_ = param
      self.modeKey = "router-seg-sec-policy"
      self.longModeKey = "router-seg-sec-policy-%s" % self.policyName_
      CliMode.ConfigMode.__init__( self, param, parentMode=FirewallConfigMode )

   def commentKey( self ):
      return self.longModeKey

#-------------------------------------------------------------------------------
# The "config-router-seg-sec-vrf" mode.
#-------------------------------------------------------------------------------
class FirewallVrfConfigMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.vrfName_

   def __init__( self, param ):
      self.vrfName_ = param
      self.modeKey = "router-seg-sec-vrf"
      self.longModeKey = "router-seg-sec-vrf-%s" % self.vrfName_
      CliMode.ConfigMode.__init__( self, param, parentMode=FirewallConfigMode )

   def commentKey( self ):
      return self.longModeKey

#-------------------------------------------------------------------------------
# The "config-router-seg-sec-vrf-segment" mode.
#-------------------------------------------------------------------------------
class FirewallVrfSegmentConfigMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'segment %s' % self.segment_

   def __init__( self, param ):
      self.segment_ = param
      self.modeKey = "router-seg-sec-vrf-segment"
      self.longModeKey = "router-seg-sec-vrf-segment-%s" % self.segment_
      CliMode.ConfigMode.__init__( self, param, parentMode=FirewallVrfConfigMode )

   def commentKey( self ):
      return self.longModeKey

#-------------------------------------------------------------------------------
# The "config-router-seg-sec-vrf-seg-def" mode.
#-------------------------------------------------------------------------------
class ClassMapFirewallVrfConfigMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'definition'

   def __init__( self, param ):
      self.modeKey = 'router-seg-sec-vrf-segment-def'
      self.longModeKey = self.modeKey
      self.className = param
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=FirewallVrfSegmentConfigMode )

   def commentKey( self ):
      return self.longModeKey

#-------------------------------------------------------------------------------
# The "config-router-seg-sec-vrf-segment-policies" mode.
#-------------------------------------------------------------------------------
class VrfSegmentPolicyMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'policies'

   def __init__( self, param ):
      self.modeKey = 'router-seg-sec-vrf-segment-policies'
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=FirewallVrfSegmentConfigMode )

   def commentKey( self ):
      return self.longModeKey

#-------------------------------------------------------------------------------
# The "config-router-seg-sec-segment" mode.
#-------------------------------------------------------------------------------
class FirewallSegmentConfigMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'segment %s' % self.segment_

   def __init__( self, param ):
      self.segment_ = param
      self.modeKey = "router-seg-sec-segment"
      self.longModeKey = "router-seg-sec-segment-%s" % self.segment_
      CliMode.ConfigMode.__init__( self, param, parentMode=FirewallConfigMode )

   def commentKey( self ):
      return self.longModeKey

#-------------------------------------------------------------------------------
# The "config-router-seg-sec-seg-def" mode.
#-------------------------------------------------------------------------------
class ClassMapFirewallConfigMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'definition'

   def __init__( self, param ):
      self.modeKey = 'router-seg-sec-segment-def'
      self.longModeKey = self.modeKey
      self.className = param
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=FirewallSegmentConfigMode )

   def commentKey( self ):
      return self.longModeKey

#-------------------------------------------------------------------------------
# The "config-router-seg-sec-segment-policies" mode.
#-------------------------------------------------------------------------------
class SegmentPolicyMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'policies'

   def __init__( self, param ):
      self.modeKey = 'router-seg-sec-segment-policies'
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=FirewallSegmentConfigMode )

   def commentKey( self ):
      return self.longModeKey
