# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
import ExternalServicesConstants

class ExternalHttpServicesVrfConfigModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.vrfName_

   def __init__( self, param ):
      ( self.vrfName_, self.config_ ) = param
      self.modeKey = "mgmt-api-external-services-vrf"
      self.longModeKey = "mgmt-api-external-services-vrf-%s" % self.vrfName_
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.ConfigMode )
      if ExternalServicesConstants.SERVICE_NAME not in self.config().vrfService:
         self.config().vrfService[ ExternalServicesConstants.SERVICE_NAME ] = False

   def config( self ):
      return self.config_.vrfConfig.newMember( self.vrfName_ )

   def shutdown( self ):
      self.config().vrfService[ ExternalServicesConstants.SERVICE_NAME ] = False

   def noShutdown( self ):
      self.config().vrfService[ ExternalServicesConstants.SERVICE_NAME ] = True
