#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class EventHandlerMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'event-handler %s' % self.param_

   def __init__( self, param ):
      self.modeKey = "handler"
      self.longModeKey = "handler-%s" % param
      CliMode.ConfigMode.__init__( self, param )

class TriggerOnCountersMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'trigger on-counters'

   def __init__( self, param ):
      self.modeKey = "counters"
      self.longModeKey = "handler-%s-counters" % param
      CliMode.ConfigMode.__init__( self, None, parentMode=EventHandlerMode )

class TriggerOnLoggingMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'trigger on-logging'

   def __init__( self, param ):
      self.modeKey = "logging"
      self.longModeKey = "handler-%s-logging" % param
      CliMode.ConfigMode.__init__( self, None, parentMode=EventHandlerMode )

