#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class EoamConfigModeBase( CliMode.ConfigMode ):
   autoConfigSessionAllowed = False

   def enterCmd( self ):
      return 'monitor ethernet oam '

   def __init__( self ):
      self.modeKey = 'eoam'
      self.longModeKey = 'eoam'
      CliMode.ConfigMode.__init__( self, self.longModeKey )

class EoamProfileModeBase( CliMode.ConfigMode ):
   autoConfigSessionAllowed = False

   def enterCmd( self ):
      return 'profile %s' % self.profileName

   def __init__( self, param ):
      self.profileName  = param
      self.modeKey = 'eoam-profile'
      self.longModeKey = 'eoam-profile-%s' % self.profileName
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=EoamConfigModeBase )

class LinkMonitoringModeBase( CliMode.ConfigMode ):
   autoConfigSessionAllowed = False

   def enterCmd( self ):
      return 'link-error '

   def __init__( self, param ):
      self.modeKey = 'eoam-profile-link-error'
      self.longModeKey = 'eoam-profile-%s-link-error' % param
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=EoamProfileModeBase )
