# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class HardwareAclPermitDuringUpdateMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'hardware access-list update default-result permit'

   def __init__( self, param ):
      self.modeKey = ""
      self.longModeKey = ""
      CliMode.ConfigMode.__init__( self, param )

class HardwareAclIngressSharingMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'hardware access-list resource sharing vlan in'

   def __init__( self, param ):
      self.modeKey = ""
      self.longModeKey = ""
      CliMode.ConfigMode.__init__( self, param )

class HardwareAclEgressIp6SharingMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'hardware access-list resource sharing vlan ipv6 out'

   def __init__( self, param ):
      self.modeKey = ""
      self.longModeKey = ""
      CliMode.ConfigMode.__init__( self, param )

class HardwareAclEgressIpSharingOnMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'hardware access-list resource sharing vlan ipv4 out'

   def __init__( self, param ):
      self.modeKey = ""
      self.longModeKey = ""
      CliMode.ConfigMode.__init__( self, param )

class HardwareAclEgressIpSharingOffMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'no hardware access-list resource sharing vlan ipv4 out'

   def __init__( self, param ):
      self.modeKey = ""
      self.longModeKey = ""
      CliMode.ConfigMode.__init__( self, param )
