# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class Dot1xBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'dot1x'

   def __init__( self, param ):
      self.modeKey = "dot1x"
      self.longModeKey = "dot1x"
      CliMode.ConfigMode.__init__( self, param )

class Dot1xSuppProfileBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'supplicant profile %s' % self.profileName

   def __init__( self, param ):
      self.modeKey = "supp-profile"
      self.profileName = param
      self.longModeKey = "dot1x-supp-profile-%s" % self.profileName

      CliMode.ConfigMode.__init__( self, param )
