# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

#
# Device-health sub-mode
#
class DeviceHealthMode( CliMode.ConfigMode ):
   
   def enterCmd( self ):
      return "monitor device-health"
   
   def __init__( self ):
      self.modeKey = "mon-device-health"
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, None )
   
#
# Category sub-mode.
#
class CategoryMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "category %s" % self.param

   def __init__( self, param ):
      self.param = param
      self.modeKey = "category"
      self.longModeKey = "mon-device-health-cat-%s" % self.param
      CliMode.ConfigMode.__init__( self, None )
