#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class DecapGroupBaseMode( CliMode.ConfigMode ):
   def __init__( self, dgName ):
      self.modeKey = 'dg'
      self.longModeKey = 'dg-%s' % dgName
      self.dgName = dgName
      CliMode.ConfigMode.__init__( self, dgName )

   def enterCmd( self ):
      return 'ip decap-group %s' % self.dgName
