# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class ConnectivityMonitorBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'monitor connectivity'

   def __init__( self, param ):
      self.modeKey = 'mon-connectivity'
      self.longModeKey = 'mon-connectivity'
      CliMode.ConfigMode.__init__( self, param )

class ConnectivityMonitorHostMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'host %s' % self.hostName

   def __init__( self, param ):
      self.modeKey = 'host'
      self.hostName = param[ 0 ]
      self.longModeKey = 'mc-%s' % self.hostName
      if param[ 1 ] != 'default':
         self.longModeKey = 'mc-vrf-%s-host-%s' % ( param[ 1 ], param[ 0 ] )
      CliMode.ConfigMode.__init__( self, param )

class ConnectivityMonitorVrfMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'vrf %s' % self.vrfName

   def __init__( self, param ):
      self.modeKey = 'vrf'
      self.vrfName = param
      self.longModeKey = 'mc-vrf-%s' % self.vrfName
