# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import CliMode

class CliRelayConfigModeBase( CliMode.ConfigMode ): 

   def enterCmd( self ): 
      return 'service cli-relay'

   def __init__( self, param=None ): 
      self.modeKey = 'cvx-cli-relay'
      if param: 
         self.longModeKey = 'cvx-cli-relay-%s' % param
      else: 
         self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, None, parentMode=CliMode.ConfigMode )

class ShowCommandConfigModeBase( CliRelayConfigModeBase ): 

   def enterCmd( self ): 
      if self.switchMac != '':
         switchMac = self.switchMac.replace( '-', '' )
         switchMac = '.'.join( [ switchMac[i:i+4] for i in range( 
            0, len(switchMac), 4 ) ] )
         return 'switch mac %s %s' % ( switchMac, self.cmdId )
      if self.hostName != '':
         return 'switch host %s %s' % ( self.hostName, self.cmdId )

   def __init__( self, param ): 
      ( self.switchMac, self.hostName, self.cmdId ) = param
      CliRelayConfigModeBase.__init__( self, param=self.cmdId )

