#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class CfmModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'cfm'

   def __init__( self, param ):
      self.modeKey = 'cfm'
      self.longModeKey = 'cfm'
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.ConfigMode )

class MaintenanceDomainModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return '%s %s' % ( 'domain', self.mdLevel )

   def __init__( self, param ):
      self.mdLevel = param
      self.modeKey = ( "cfm-md%s" % self.mdLevel )
      self.longModeKey = ( "cfm-md%s" % self.mdLevel )
      CliMode.ConfigMode.__init__( self, param, parentMode=CfmModeBase )

class CfmProfileModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return '%s %s' % ( 'profile', self.cfmProfileName )

   def __init__( self, param ):
      self.cfmProfileName = param
      self.modeKey = ( "cfm-profile-%s" % self.cfmProfileName )
      self.longModeKey = ( "cfm-profile-%s" % self.cfmProfileName )
      CliMode.ConfigMode.__init__( self, param, parentMode=CfmModeBase )

class MaintenanceAssociationModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return '%s %s' % ( 'association', self.maNameId )

   def __init__( self, param ):
      ( self.mdLevel, self.maNameId ) = param
      self.modeKey = ( "cfm-md%s-ma-%s" % ( self.mdLevel, self.maNameId ) )
      self.longModeKey = ( "cfm-md%s-ma-%s" % ( self.mdLevel, self.maNameId ) )
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=MaintenanceDomainModeBase )

class LocalMaintenanceEndPointModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return '%s %s' % ( 'endpoint', self.localMepId )

   def __init__( self, param ):
      ( self.mdLevel, self.maNameId, self.localMepId ) = param
      self.modeKey = ( "cfm-md%s-ma-%s-mep%s" % ( self.mdLevel, self.maNameId,
                                                  self.localMepId ) )
      self.longModeKey = ( "cfm-md%s-ma-%s-mep%s" % ( self.mdLevel, self.maNameId,
                                                      self.localMepId ) )
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=MaintenanceAssociationModeBase )
