# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class CapiVrfConfigModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.vrfName_

   def __init__( self, param ):
      ( self.vrfName_, self.config_ ) = param
      self.modeKey = "mgmt-api-http-cmds-vrf"
      self.longModeKey = "mgmt-api-http-cmds-vrf-%s" % self.vrfName_
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.ConfigMode )
   
   def config( self ):
      return self.config_.vrfConfig.newMember( self.vrfName_ )

