# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import CliMode
from CliMode.BgpCommon import RoutingBgpBaseMode

class RoutingBmpStationMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'monitoring station %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'router'
      self.bmpStationName = param
      self.longModeKey = 'router-bgp-monitoring-station-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingBgpBaseMode )

   def commentKey( self ):
      return self.longModeKey

