# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.MaintenanceMode import MaintenanceMode

class BgpMaintenanceProfileMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'profile bgp %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'profile-bgp'
      self.longModeKey = 'profile-bgp-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=MaintenanceMode )

   def commentKey( self ):
      return self.longModeKey
