#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.BgpCommon import RoutingBgpBaseMode

class BgpMacVrfMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      if self.isVpws:
         cmd = 'vpws '
      elif self.isVniMacVrf:
         cmd = 'vni-aware-bundle ' if self.isBundle else 'vni '
      else:
         cmd = 'vlan-aware-bundle ' if self.isBundle else 'vlan '
      return cmd + self.macVrfId

   # macvrf's can be created using the 'vlan' based CLI (on a switch) or the 
   # 'vni' based CLI (on a CVX). 'isVniMacVrf' indicates  whether it is a 
   # VNI based MacVrf
   # There are also "VPWS" macvrf's, created using the 'vpws' CLI.
   def __init__( self, vrfName, isBundle, isVniMacVrf=False, isVpws=False ):
      # for mac vrfs
      # stand alone mac vrfs are named vlan.<vlan id> or vni.<vni.id>
      # vlan/vni aware bundles are named vlanbundle/vnibundle.<bundle name>
      # we will set self.macVrfId to either vlan id or bundle name
      self.isBundle = isBundle
      self.isVniMacVrf = isVniMacVrf
      self.isVpws = isVpws
      self.macVrfType, self.macVrfId = vrfName.split( '.', 1 )
      self.modeKey = 'macvrf-' + self.macVrfId
      self.longModeKey = 'macvrf-' + self.macVrfId
      CliMode.ConfigMode.__init__( self, vrfName, parentMode=RoutingBgpBaseMode )

   def commentKey( self ):
      return self.longModeKey

class BgpMacVrfVpwsPwMode( CliMode.ConfigMode ):
   def __init__( self, pwName ):
      self.pwName = pwName
      self.modeKey = 'vpws-pw-{}'.format( self.pwName )
      self.longModeKey = 'vpws-pw-{}'.format( self.pwName )
      super( BgpMacVrfVpwsPwMode, self ).__init__(
            self.pwName,
            parentMode=BgpMacVrfMode )

   def enterCmd( self ):
      return 'pseudowire {}'.format( self.pwName )

   def commentKey( self ):
      return self.longModeKey
