# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class BgpGroupMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'group bgp %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'group-bgp'
      self.longModeKey = 'group-bgp-%s' % param
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return self.longModeKey

class BgpBuiltinGroupMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'group bgp %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'builtin-group-bgp'
      self.longModeKey = 'builtin-group-bgp-%s' % param
      CliMode.ConfigMode.__init__( self, param )
